#!/usr/local/bin/perl
# v1.2 (c) 2004 by Don Blaheta
# Released under the Artistic Licence
# http://www.opensource.org/licenses/artistic-license.php

use MT::BotBlockAlg;

my $alg = random MT::BotBlockAlg();
if (@ARGV) {
  $alg = get MT::BotBlockAlg($ARGV[0]);
}
printf "Alg: %s\n", $alg->name();

my $code = $alg->generate();
print "Code: $code\n";

printf "Prompt: %s\n", $alg->prompt();
printf "Output: %s\n", $alg->output($code);

local $MT::BotBlockQuestions::key = $code;
printf "(Expects %s;%s VALID method present)\n",
	&{$alg->{EXPECT}}(), (exists $alg->{VALID}? "": " no");

$| = 1;
print "> ";
chomp(my $ans = <STDIN>);

printf "Valid: %s\n", $alg->validate($code, $ans);
