# v1.2.2 (c) 2004 by Don Blaheta
# Released under the Artistic Licence
# http://www.opensource.org/licenses/artistic-license.php
# Based loosely on SCode by James Seng

package MT::BotBlockQuestions;
use strict;

our ($key, $response);

###############################################
#                                             #
# The questions.  Edit these or add your own! #
#  See doc/questions.html for instructions.   #
#                                             #
###############################################

# register MT::BotBlockAlg (
#       NAME => "...",
#       PROMPT => "...",
#       EXPECT => sub { ... }
#     );

register MT::BotBlockAlg (
      NAME => "add one",
      PROMPT => "Add one to this number:",
      EXPECT => sub { $key + 1; }
    );

register MT::BotBlockAlg (
      NAME => "tens even/odd",
      PROMPT => "Say whether the tens digit of this number is even or odd:",
      EXPECT => sub { int($key/10)%2? "odd": "even" }
    );

#register MT::BotBlockAlg (
#      NAME => "multiple",
#      GEN => sub { 1 + int rand (20) },
#      PROMPT => "Give a multiple of this number:",
#      VALID => sub { $response % $key == 0  &&  $response > $key}
#    );

register MT::BotBlockAlg (
      NAME => "read numbers",
      PROMPT => "Write this number out in numeral form:",
      OUT => sub { num_to_words($key) },
      EXPECT => sub { $key }
    );

register MT::BotBlockAlg (
      NAME => "year future/past",
      GEN => sub { int rand (200) },
      PROMPT => "",
      OUT =>
        sub { "Is the year AD" . (1900+$key) . " in the future or the past?" },
      VALID => sub {
	return ($key <= (localtime)[5] && $response =~ /^\s*past/i)
	    || ($key >= (localtime)[5] && $response =~ /^\s*future/i);
      }
    );


###
#auxiliary functions

sub num_to_words { numlist_to_words(num_to_list(@_)) }

sub numlist_to_words {
  if (@_ >= 3
      || @_ == 2 && $_[$#_] =~ /hundred$/) {
    return shift() . ", " . numlist_to_words(@_);
  } elsif (@_ == 2) {
    return shift() . " and " . numlist_to_words(@_);
  } elsif (@_ == 1) {
    return shift();
  } else {
    return "";
  }
}

sub num_to_list {
  my $num = shift;
  if ($num >= 1_000_000_000_000) {
    return num_part ($num, 1_000_000_000_000, "trillion");
  } elsif ($num >= 1_000_000_000) {
    return num_part ($num, 1_000_000_000, "billion");
  } elsif ($num >= 1_000_000) {
    return num_part ($num, 1_000_000, "million");
  } elsif ($num >= 1000) {
    return num_part ($num, 1_000, "thousand");
  } elsif ($num >= 100) {
    return num_part ($num, 100, "hundred");
  } else {
    return num2dig ($num);
  }
}

sub num2dig {
  my $num = shift;
  if ($num >= 20 && $num % 10 == 0) {
    return
      (qw(zero ten twenty thirty forty 
          fifty sixty seventy eighty ninety))[$num/10];
  } elsif ($num >= 20) {
    return num2dig (10 * int ($num/10)) . " " .
           num2dig ($num % 10);
  } else { 
    return 
      (qw(zero one two three four five six seven eight nine 
          ten eleven twelve thirteen fourteen 
            fifteen sixteen seventeen eighteen nineteen))[$num];
  }
}

sub num_part {
  my ($num, $base, $basename) = @_;
  my $first = int($num/$base);
  my $second = $num % $base;
  if ($second) {
    return (numlist_to_words(num_to_list($first)) . " " . $basename,
	   num_to_list($second));
  } else {
    return (numlist_to_words(num_to_list($first)) . " " . $basename);
  }
}

1;
