# v1.2 (c) 2004 by Don Blaheta
# Released under the Artistic Licence
# http://www.opensource.org/licenses/artistic-license.php
# Based loosely on SCode by James Seng

################################################
#                                              #
# You shouldn't have to edit this file at all. #
#                                              #
################################################

package MT::BotBlockAlg;
use strict;

my @algs = ();
my %alg = ();

require MT::BotBlockQuestions;  # loads questions


sub new {
  my $invocant = shift;
  my $class = ref $invocant || $invocant;

  return bless
    +{NAME => "",
      GEN => sub { int rand (1000) },
      PROMPT => "Type this number:",
      OUT => sub { $MT::BotBlockQuestions::key },
      EXPECT => sub { $MT::BotBlockQuestions::key },
      @_},
    $class;
}

sub register {
  my $invocant = shift;
  my $class = ref $invocant || $invocant;

  my $alg = $class->new (@_);
  push @algs, $alg;
  $alg{$alg->{NAME}} = $alg;
}

sub random { $algs[int rand @algs] }

sub get {
  my $invocant = shift;
  my $class = ref $invocant || $invocant;

  my $name = shift;

  return $alg{$name};
}

sub name {
  my $self = shift;
  return $self->{NAME};
}

sub generate {
  my $self = shift;
  return &{$self->{GEN}}();
}

sub prompt {
  my $self = shift;
  return $self->{PROMPT};
}

sub output {
  my $self = shift;
  local $MT::BotBlockQuestions::key = shift;
  return &{$self->{OUT}}();
}

sub validate {
  my $self = shift;
  local ($MT::BotBlockQuestions::key, $MT::BotBlockQuestions::response) = @_;
  if (exists $self->{VALID}) {
    return &{$self->{VALID}}();
  } else {
    return lc($MT::BotBlockQuestions::response) eq lc(&{$self->{EXPECT}}());
  }
}

1;
