# v1.2.2 (c) 2004 by Don Blaheta
# Released under the Artistic Licence
# http://www.opensource.org/licenses/artistic-license.php
# Based loosely on SCode by James Seng

package MT::BotBlock;
use MT::BotBlockAlg;
require 5.004;   # otherwise call srand with a good seed
use strict;

###############################
#                             #
# Define the follow variables #
#                             #
###############################

# tmp directory
my $tmpdir = "/home/blahedo/wwwtmp/";

# max number of temp files
my $maxtmp = 600;

# timeout (in days)
my $timeout = 0.02; #just under a half hour

# set to a valid local filename
my $logfile = "/home/blahedo/wwwtmp/mt-botblock-log";
# my $logfile = "";

# set to 0 to turn off logging; 2 is most verbose
my $loglevel = 2;

##################################
#                                #
# Do not modify below this point #
#                                #
##################################

###
#public static methods

sub block {
  my $bb = generate MT::BotBlock ();
  if (ref $bb) {
    return $bb->html();
  } else {
    return "Sorry!  Spammers have temporarily overloaded the system. ".
	"Reload this window in a little while to try again.";
  }
}

sub verify {
  my ($index, $response) = @_;
  my $bb = get MT::BotBlock ($index);
  if (!ref $bb) {
    return 0;
  }
  retire ($index);
  my $valid = $bb->validate($response);
  logmsg (1, sprintf ("%1d %s\n  %-6d %s\n  ->%s<-\n",
      !!$valid, scalar(localtime), $bb->code(), $bb->alg()->name(), 
	substr($response, 0, 100)));  # no reason to spam the logfile
  return $valid;
}

###
#private static methods

sub logmsg {
  my $level = shift;
  my $msg = shift;
  if ($level <= $loglevel && $logfile) {
    open (LOG, ">>", $logfile);
    print LOG $msg;
    close LOG;
  } 
}

sub retire {
  my $index = shift;

  if ($index >= 0 && $index < $maxtmp) {
    unlink filename($index);
  }
}

sub freeindex {
  my $init = time % $maxtmp;
  my $i = $init;
  while (-e filename($i)) {
    if (-M filename($i) > $timeout) {
      retire ($i);
      logmsg (2, sprintf ("\t---%-25s init %3d, retired %3d\n",
		scalar(localtime), $init, $i));
      return $i;
    }
    $i = ($i + 1) % $maxtmp;

    if ($i == $init) {
      logmsg (2, sprintf ("\t---%-25s init %3d, failed at %3d\n",
		scalar(localtime), $init, $i));
      return -1;
    }
  }

  logmsg (2, sprintf ("\t---%-25s init %3d, noexist %3d\n",
		scalar(localtime), $init, $i));
  return $i;
}

sub filename {
  my $i = shift;
  return $tmpdir . "BotBlock-" . $i;
}

###
#methods that deal with BotBlock objects

sub generate {
  my $invocant = shift;
  my $class = ref $invocant || $invocant;

  my $alg = random MT::BotBlockAlg ();
  my $code = $alg->generate();
  my $index = freeindex();

  return "" if ($index == -1);

  my $bb = bless +{INDEX => $index, ALG => $alg, CODE => $code}, $class;
  open FO, ">", filename($index);
  print FO $bb->toString();
  close FO;

  return $bb;
}


sub get {
  my $invocant = shift;
  my $class = ref $invocant || $invocant;

  my $index = shift;

  open FI, "<", filename($index)
    or return "";

  chomp(my $stringrep = <FI>);
  close FI;

  my ($code, $algname) = ($stringrep =~ /^\s*(\d+)\s*(.*?)\s*$/)
    or return "";

  my $alg = get MT::BotBlockAlg($algname)
    or return "";

  return bless +{INDEX => $index, ALG => $alg, CODE => $code}, $class;
}

sub toString {
  my $self = shift;

  sprintf "%d\t%s", $self->code(), $self->alg()->name();
}

sub html {
  my $self = shift;
  my $alg = $self->alg();
  sprintf <<EOM , $self->index(), $alg->prompt(), $alg->output($self->code());
  <!-- BotBlock check -->
  <input type="hidden" id="bb-index" name="bb-index" value="%d" />
  %s %s <br />
  <input id="bb-response" name="bb-response" />
  <!-- end BotBlock check -->
EOM
}

sub validate {
  my $self = shift;
  my ($response) = @_;

  return $self->alg()->validate($self->code(), $response);
}

sub index {
  my $self = shift;
  return $self->{INDEX};
}

sub alg {
  my $self = shift;
  return $self->{ALG};
}

sub code {
  my $self = shift;
  return $self->{CODE};
}

1;
